# Include file for Hero. This file contains the macros used in Hero.cds to define
# the Powers, Skills, etc.

# power:
#	cost = cost per level if minlev set, else total cost for fixed-cost item.
#	minlev = minimum level allowed, else empty for fixed-cost item.
#	end = number of active points per END required for use.
#	ce = check expression.
#	range = meters per level
#	class = class of power
#	format = format string (use ^n to get the name, etc.).
#	sformat = Selection format.
#	formula = the formula to use to compute the cost.
#	adj = any adjustments that should be made.
#	endExcludeAdds = Defined if you want adds to be excluded from the cost END is based on
#	varname = variable name to use.

$$macro power(name, cost, minlev, end, ce, range, class, format, sformat, formula, adj, 
	endExcludeAdds, varname)
{{
	item "$(name)"
	$$ifdef(varname)
		varname "$(varname)"
	$$else
		varname power
	$$endif
	uniquevar

	$$ifdef(adj)
		adj "$(adj)"
	$$endif
	$$ifdef(minlev)
		$$ifdef(formula)
			formula "$(formula)"
		$$else
			formula dround(x*$(cost))
		$$endif
		$$ifdef(ce)
			checkexp "ce($(ce),c)"
		$$else
			checkexp "ce(x>=$(minlev),c)"
		$$endif
		level $(minlev)
	$$else
		# Fixed cost
		editdlg 4
		$$ifdef(cost)
			cost $(cost)
			$$ifdef(ce)
				checkexp "ce($(ce),c)"
			$$else
				checkexp "ce(x=$(cost),c)"
			$$endif
		$$else
			cost 0
			checkexp ce(1,c)
		$$endif
		formula x
		level $(cost)
	$$endif
	totalcostformula "totalcost(@bc@,a,@mo@,@fm@,@fd@)"

	$$ifdef(class)
		cat "$(class)"
	$$endif

	$$ifdef(format)
		format "%0rx|ct(0)|%7lx|sl(0)|$(format)%-5rx'de(0)'"
	$$else
		format "%0rx|ct(0)|%7lx|sl(0)|^vd6 ^n%-5rx'de(0)'"
	$$endif

	$$ifdef(sformat)
		sformat "%0ln%-22lt%-10r!$(sformat)"
	$$else
		$$ifdef(minlev)
			sformat "%0ln%-22lt%-10r!$(cost)/1d6"
		$$else
			sformat "%0ln%-22lt%-10r!$(cost)"
		$$endif
	$$endif

	opt
                $$ifdef(end)
                        $$ifdef(endExcludeAdds)
                               begin exp END "endCost(0,$(end))" noprint end
                        $$else
                               begin exp END "endCost(1,$(end))" noprint end
                        $$endif
                $$endif
		$$ifdef(range)
			exp Range "$(range)"
		$$endif
		end
}}


# Common adjustment power options

$$macro adjPowerOptions(name)
{{
	opt
		begin frac "$(name)" "?:1;turn,+0;min.,+;5 min.,+;hour,+;5 hours,+1;day,+1;week,+1;month,+1;season,+2;year,+2;5 years,+2;decade,+2;5 decades,+3;century,+3" noprint end
		frac Affects "?:1;Single Power,+0;Single Power of Special Effect,+;All Powers of Special Effect,+2"
		end
}}



# char -- characteristic added as a power.

$$macro char(name, cost, primary, astat1, astat2, astat3, astat4, end, formula)
{{
	item "$(name)"
	$$ifdef(formula)
		formula "$(formula)"
	$$else
		formula round(x*$(cost))
	$$endif
	level 1
	checkexp x>0
	cat Standard;Characteristic
	adj "a_$(name)+`Add to Characteristics`?x:0$$ifdef(astat1);$(astat1)+`Doesn't Affect Figured`?0:x$$endif$$ifdef(astat2);$(astat2)+`Doesn't Affect Figured`?0:x$$endif$$ifdef(astat3);$(astat3)+`Doesn't Affect Figured`?0:x$$endif$$ifdef(astat4);$(astat4)+`Doesn't Affect Figured`?0:x$$endif"
	totalcostformula "totalcost(@bc@,a,@mo@,@fm@,@fd@)"

	format "%0rx|ct(0)|%7lx|sl(0)|+^v ^n%-5rx'de(0)'"
	sformat "%0ln%-10r!$(cost) per pt"

	opt
		begin text "Add to Characteristics" "?+1;" noprint dispexp 'l' end
		$$ifdef(primary)
			frac "Doesn't Affect Figured" "?+0;-"
		$$endif
		$$ifdef(end)
			begin exp END "endCost(1,$(end))" noprint end
		$$endif
		end
}}


# mainchar -- main characteristics for generic character sheets.

$$macro mainchar(name, cost, start, formula)
{{
	item "$(name)"
	$$ifdef(formula)
		formula "$(formula)+a_$(name)*0"
		defFormula "a_$(name)*0"
		default "$(start)"
		usedefault 1
	$$else
		formula "cc(x,$(cost),$(start),m_$(name))+a_$(name)*0"
		default "$(start)"
	$$endif
	level "$(start)"
	varname $(name)
	adj "t_$(name)=a_$(name)?format('/%d',$(name)+a_$(name)):''"

	format "%0lv^x't_$(name)'%11ln%-5rc"
	sformat "%0ln%-10r!$(cost) per pt"
	opt	begin exp Base "$(start)" noprint end
		begin exp "Cost per Point" "$(cost)" noprint end
		begin exp "Maximum" "m_$(name)" noprint end
		end
}}



# disad -- disadvantage with a simple cost structure.

$$macro disad(name, cost, cat, prereq)
{{
	item "$(name)"
	cost $(cost)
	$$ifdef(cat)
		cat "$(cat)"
	$$endif

	$$ifdef(prereq)
		prereq "$(prereq)"
	$$endif

	totalcostformula "round((c+a)*m)"
	editdlg 4
	format "%0rx|ct(0)|%7ln"
	sformat "%0ln%-10rc"
}}

$$macro psychLim(name, situation, intensity)
{{
	item "$(name)"
	cat "Psych. Lim."

	editdlg 2
	format "%0rx|ct(0)|%7ln (^o'Situation', ^o'Intensity')"
	sformat %0ln%-10r!Varies
	totalcostformula "round((c+a)*m)"

	opt	begin add Situation "?:$(situation);Uncommon,+5;Common,+10;Very Common,+15" noprint end
		begin add Intensity "?:$(intensity);Moderate,+0;Strong,+5;Total,+10" noprint end
		end
}}

# disad -- disadvantage with a level cost structure.

$$macro disadlev(name, cost, cat, format, sformat)
{{
	item "$(name)"
	level 1
	formula "x*$(cost)"
	$$ifdef(cat)
		cat "$(cat)"
	$$endif
	checkexp "x>0"

	totalcostformula "round((c+a)*m)"
	format "%0rx|ct(0)|%7l!$(format)"
	sformat "%0ln%-10r!$(sformat)"
}}



# disadopt -- disadvantage with costs indicated by the options.

$$macro disadopt(name, format, cat, prereq)
{{
	item "$(name)"
	$$ifdef(cat)
		cat "$(cat)"
	$$endif
	$$ifdef(prereq)
		prereq "$(prereq)"
	$$endif

	editdlg 2
	$$ifdef(format)
		format "%0rx|ct(0)|%7l!$(format)"
	$$else
		format %0rx|ct(0)|%7ln
	$$endif
	sformat %0ln%-10r!Varies
	totalcostformula "round((c+a)*m)"
}}


# lang -- language.

$$macro lang(name, native)
{{
	item "$(name)"
		cat Language
		format "%0rx|ct(0)|%7ln (^o'Fluency')"
		sformat %0ln%-25lt%-10r!Varies
		totalcostformula "max(round((c+a)*m),0)"
	
		varname lang
		uniquevar

		$$ifdef(native)
			original "$(name)"
			level 4
			formula max(0,x-4-&x)
			checkexp "x>3 and x<6"
		$$else
			original Language
			level 1
			formula max(1,x-&x)
			checkexp "x>0 and x<6"
		$$endif
		opt	begin exp Fluency "qindex(x,'Basic Conv.','Fluent Conv.','Completely Fluent w/accent','Native Accent','Imitate Dialects')" noprint end
			add Literacy "?:1;Standard,0;Literate (if not standard),1"
			end
}}



# martman -- martial maneuver

$$macro martman(name, cost, OCV, DCV, dmg, format, minLevel, varname, cat)
{{
	item "$(name)" 
	$$ifdef(cat)
		cat "$(cat)"
	$$else
		cat "Martial Maneuver"
	$$endif

	$$ifdef(minLevel)
		formula $(cost)*x
		checkexp x>=0
		$$ifdef(varname)
			varname "$(varname)"
		$$endif
		level $(minLevel)
	$$else
		editdlg 4
		$$ifdef(cost)
			level $(cost)
			checkexp "x=$(cost)"
		$$else
			level 0
		$$endif
		formula x+0*martialDC*total_str
		varname martman
	$$endif
	$$ifdef(format)
		format "%0rx|ct(0)|%7l!$(format)"
	$$else
		$$ifdef(dmg)
			format "%0rx|ct(0)|%7ln (OCV ^o'OCV', DCV ^o'DCV', ^o'Damage')"
		$$else
			format "%0rx|ct(0)|%7ln (OCV ^o'OCV', DCV ^o'DCV')"
		$$endif
	$$endif
	$$ifdef(minLevel)
		sformat "%0ln%-25lt%-10r!$(cost) per +1"
	$$else
		sformat "%0ln$$ifdef(OCV) (^o'OCV'/^o'DCV')$$endif%-25lt%-4r!$(cost)"
	$$endif
	opt
		$$ifdef(OCV)
			begin text OCV "??$(OCV)" noprint end
		$$endif
		$$ifdef(DCV)
			begin text DCV "??$(DCV)" noprint end
		$$endif
		$$ifdef (dmg)
			begin exp Damage "$(dmg)" noprint end
		$$endif
		end
}}


# martart -- martial art. 
# cost = base cost.
# autoitems = list of martial maneuvers added automatically.

$$macro martart(name, cost, autoitems, cat)
{{
	item "$(name)" 
	addwholelist
	$$ifdef(cat)
		cat "$(cat)"
	$$else
		cat "Martial Arts Style"
	$$endif
	cost $(cost)
	format "%0rx|ct(0)|%5ln"
	sformat %0ln%-25lt%-4rc
	addaslist autochargecost
	$$ifdef(autoitems)
		autoitems "$(autoitems)"
	$$endif
}}


# skill -- general skill

$$macro skill(name, class, base, bc, cm, varname, cat, format)
{{
	item "$(name)"
	class "$(class)"
	$$ifdef(cat)
		cat "$(cat)"
	$$endif
	$$ifdef(base)
		formula "skCost(x,&x,total_$(base),$(bc),$(cm))"
		checkexp "x=8 or c>=$(bc)-&x"
		level "initsk(total_$(base))"
	$$else
		formula "genCost(x,&x,$(bc),$(cm))"
		checkexp "x=8 or c>=$(bc)-&x"
		level "initsk(10)"
	$$endif

	$$ifdef(format)
		format "%0rx|ct(0)|%7l!$(format)%-5rv-"
	$$else
		format "%0rx|ct(0)|%7ln%-5rv-"
	$$endif
	sformat %0ln%-25ll%-4r!$(bc)/$(cm)
	$$ifdef(varname)
		varname $(varname)
	$$endif
	totalcostformula "totalcost(@bc@,a,@mo@,@fm@,@fd@)"
}}


# Generic skill -- start off as generic, then let user change.
# Need to add options for Type = INT, DEX, Background, etc.
# Optionally add Base and Increase. If Base is omitted, assumed to be
# 3 for CHA-based skills and 2 for Background. Increase is assumed to
# be 1 if omitted.

$$macro gskill(name, class, varname, cat, format)
{{
	item "$(name)"
	class "$(class)"
	$$ifdef(cat)
		cat "$(cat)"
	$$endif
	formula "gskillcost(x,&x)"
	checkexp "gskillcheck(x,c,&x)"
	level 11

	$$ifdef(format)
		format "%0rx|ct(0)|%7l!$(format)%-5rv-"
	$$else
		format "%0rx|ct(0)|%7ln%-5rv-"
	$$endif
	sformat %0ln%-25ll%-7r!2-3/1
	$$ifdef(varname)
		varname $(varname)
	$$endif
	totalcostformula "totalcost(@bc@,a,@mo@,@fm@,@fd@)"
}}


# sciskill -- science skill.

$$macro sciskill(name)
{{
	item "$(name)"
	cat "Science"
	formula "gskillcost(x,&x)"
	checkexp "gskillcheck(x,c,&x)"
	level 11

	format "%0rx|ct(0)|%7ln%-5rv-"
	sformat %0ln%-25ll%-7r!2-3/1
	varname science
	opt	begin text "Type" "?:1;Background;INT" noprint end
		end
	totalcostformula "totalcost(@bc@,a,@mo@,@fm@,@fd@)"
}}


# weapfam -- weapon familiarity.

$$macro weapfam(name, cost, cat, group)
{{
	item "$(name)"
	cost $(cost)
	$$ifdef(group)
		adj "\"Skills:$(group)\"+1"
	$$endif
	level 1
	formula "&x?0:$(cost)"
	cat "Weapon Familiarity$$ifdef(cat);$(cat)$$endif"
	varname weapfam
	class "Weapon Fam."
	format %0rx|ct(0)|%7ln
	sformat %0ln%-25ll%-4rc
	editdlg 4
}}

# macro for new style of familiarities.

$$macro familiarity(name)
{{
	item "$(name)"
		editdlg 2
		cat Familiarity
		cost 0
		format "%0rx|ct(0)|%7ln (^x|listOptions('opttextvalue', '', ', ')|)"
		sformat "%0ln"
}}

$$macro famopt(name, list) {{
	begin add "$(name)" "?:1;$(list)"
			dispexp "'t: o'" noprint
			end
}}



# transfam -- transport familiarity.

$$macro transfam(name, cost, cat, group)
{{
	item "$(name)"
	cost $(cost)
	$$ifdef(group)
		adj "\"Skills:$(group)\"+1"
	$$endif
	checkexp x=1
	level 1
	formula "&x?0:$(cost)"
	cat "Transport Familiarity$$ifdef(cat);$(cat)$$endif"
	varname transfam
	class "Trans. Fam."
	format %0rx|ct(0)|%7ln
	sformat %0ln%-25ll%-4rc
	editdlg 4
}}


# skenh -- skill enhancer. Adds +1 bonus to items that have the specified class.

$$macro skenh(name, class, addadj)
{{
	item "$(name)"
	class "$(class)"
	cat "Skill Enhancer"
	adj "\"Skills:$(class)\"+1$$ifdef(addadj);$(addadj)$$endif"
	cost 3
	editdlg 4
	format "%0rx|ct(0)|%7ln"
	sformat %0ln%-25ll%-4rc
}}


# level -- skill and combat levels.

$$macro level(name, cost, class)
{{
	item "$(name)"
	$$ifdef(class)
		class "$(class)"
		cat "$(class)"
	$$else
		class "Combat Level"
		cat "Combat Level"
	$$endif
	formula "round($(cost)*x)"
	checkexp x>=1
	format "%0rx|ct(0)|%7l!+^v level w/^n"
	sformat "%0ln%-25ll%-10r!$(cost) per +1"
	level 1
}}


# perk -- perk.

$$macro perk(name, cost, formula, format, sformat, prereq, level, checkexp, extraCat)
{{
	item "$(name)"
		$$ifdef(extraCat)
			cat "Perk;$(extraCat)"
		$$else
			cat Perk
		$$endif
		$$ifdef(prereq)
			prereq "$(prereq)"
		$$endif
		$$ifdef(checkexp)
			checkexp "$(checkexp)"
		$$endif

		$$ifdef(cost)
			cost $(cost)
		$$endif

		$$ifdef(level)
			level "$(level)"
		$$endif

		$$ifdef(formula)
			formula "$(formula)"
		$$else
			editdlg 4
		$$endif

		$$ifdef(format)
			format "%0rx|ct(0)|%7l!$(format)"
		$$else
			format %0rx|ct(0)|%7ln
		$$endif

		$$ifdef(sformat)
			sformat "$(sformat)"
		$$else
			sformat %0ln%-10rc
		$$endif
}}


# talent -- talent.

$$macro talent(name, cost, extra, char, varname, format, sformat, minlev, checkexp)
{{
	item "$(name)"
	cat Talent
	totalcostformula "totalcost(@bc@,a,@mo@,@fm@,@fd@)"
	$$ifdef(extra)
		$$ifdef(varname)
			varname $(varname)
		$$endif
		$$ifdef(char)
			level "initsk($(char))"
			formula "talCost(x,$(char),$(cost),$(extra))"
		$$else
			formula "$(cost)+(x-1)*$(extra)"
		$$endif
		$$ifdef(minlev)
			$$ifdef(checkexp)
				checkexp "$(checkexp)"
			$$else
				checkexp x>=$(minlev)
			$$endif
		$$else
			$$ifdef(checkexp)
				checkexp "$(checkexp)"
			$$else
				checkexp c>=$(cost)
			$$endif
		$$endif
		editdlg 0
	$$else
		editdlg 4
		cost $(cost)
	$$endif

	$$ifdef(format)
		format "%0rx|ct(0)|%7l!$(format)"
	$$else
		$$ifdef(extra)
			format "%0rx|ct(0)|%7ln%-5rv-"
		$$else
			format "%0rx|ct(0)|%7ln"
		$$endif
	$$endif
	$$ifdef(sformat)
		sformat "%0ln%-25ll%-10r!$(sformat)"
	$$else
		$$ifdef(extra)
			sformat %0ln%-25ll%-10r!$(cost)/$(extra)
		$$else
				sformat %0ln%-25ll%-4rc
		$$endif
	$$endif
}}


# rweap -- ranged weapon.

$$macro rweap(name, ocv, rmod, dmg, dc, stunx, strmin, shots, notes, cost)
{{
	item "$(name)"
	cat "Ranged Weapon"
	class "Weapon"
	format "%0rc%7ln (^o'Damage')"
	sformat "%0ln%-12lo'Damage'"
	keepcost
	adj equipweight+`Weight`

	$$ifdef(cost)
		cost $(cost)
	$$else
		cost 0
	$$endif
	editdlg 4
	$$ifdef(notes)
		notes "$(notes)"
	$$endif

	opt
		text OCV "$(ocv)"
		text "R Mod" "$(rmod)"
		begin text Damage "$(dmg)" noprint end
		text DC "??$(dc);$(dc);x;x>0"
		text STUNx "$(stunx)"
		$$ifdef(strmin)
			text "STR Min" "$(strmin)"
		$$endif
		$$ifdef(shots)
			text Shots "$(shots)"
		$$endif
		text Weight ??0
		end
}}


# mweap -- melee weapon.

$$macro mweap(name, ocv, dmg, dc, type, stunx, strmin, notes, cost, extradc, dcper)
{{
	item "$(name)"
	cat "Melee Weapon"
	class "Weapon"
	format "%0rc%7ln (^o'Damage', OCV: ^o'OCV')"
	sformat "%0ln%-12l!$(dmg)$(type)"
	formula x+0*total_str*martialDC
	level 0
	varname mweap
	keepcost
	adj equipweight+`Weight`

	$$ifdef(strmin)
		prereq "Characteristics:STR>=$(strmin)"
	$$endif

	$$ifdef(notes)
		notes "$(notes)"
	$$endif

	$$ifdef(cost)
		cost $(cost)
	$$else
		cost 0
	$$endif
	editdlg 4

	opt
		begin text OCV "$(ocv)" noprint end
		$$ifdef(extradc)
			begin exp Damage "weapdmg(`DC`,`STR Min`,$(extradc),$(dcper),\"$(type)\")" noprint end
		$$else
			begin exp Damage "weapdmg(`DC`,`STR Min`,5,1,\"$(type)\")" noprint end
		$$endif
		text DC "??$(dc)"
		text STUNx "$(stunx)"
		text "STR Min" "$(strmin)"
		text Weight ??0
		end
}}


# armor -- armor macro.

$$macro armor(name, pd, ed, weight, cost)
{{
	item "$(name)"
	cat Armor
	editdlg 4
	keepcost
	adj equipweight+`Weight`

	$$ifdef(cost)
		cost $(cost)
	$$else
		cost 0
	$$endif

	$$ifdef(pd)
		$$ifdef(ed)
			format "%0rc%7ln (Coverage: ^o'Coverage', PD ^o'PD', ED ^o'ED')"
		$$else
			format "%0rc%7ln (Coverage: ^o'Coverage', PD ^o'PD')"
		$$endif
	$$else
		$$ifdef(ed)
			format "%0rc%7ln (Coverage: ^o'Coverage', ED ^o'ED')"
		$$else
			format "%0rc%7ln (Coverage: ^o'Coverage')"
		$$endif
	$$endif
	sformat "%0ln%-12l!DEF $(ed)"
	
	opt
		$$ifdef(pd)
			begin adj PD rpd+x $(pd) noprint end
		$$endif
		$$ifdef(ed)
			begin adj ED red+x $(ed) noprint end
		$$endif
		exp Weight round(10*$(weight)*`Coverage`)/10
		begin text Coverage "?:8;8-,.25;9-,.375;10-,.5;11-,.625;12-,.75;14-,.875;15-,.95;Full,1" noprint end
		end
}}


# shield -- shield macro.

$$macro shield(name, dcv, weight, strmin, cost)
{{
	item "$(name)"
	cat Shield
	editdlg 4
	keepcost
	adj equipweight+`Weight`

	$$ifdef(strmin)
		prereq "Characteristics:STR>=$(strmin)"
	$$endif

	$$ifdef(cost)
		cost $(cost)
	$$else
		cost 0
	$$endif

	format "%0rc%7ln (DCV ^o'DCV')"
	sformat "%0ln%-12l!DCV $(dcv)"
	
	opt
		begin text DCV "$(dcv)" noprint end
		text Weight "??$(weight)"
		text "STR Min" "$(strmin)"
		end
}}


# equip -- general equipment macro.

$$macro equip(name, weight, cost)
{{
	item "$(name)"
	cat Equipment
	editdlg 4
	keepcost
	adj equipweight+`Weight`

	$$ifdef(cost)
		cost $(cost)
	$$else
		cost 0
	$$endif

	format "%0rc%7ln (^o'Weight'kg)"
	sformat "%0ln"
	
	opt
		begin text Weight "??$(weight)" noprint end
		end
}}


# list -- General list macro.

$$macro list(name, format, cat, totalcostformula)
{{
	item "$(name)"
		addwholelist
		$$ifdef(format)
			format "%0rx|ct(0)|%6lx|sl(0)|$(format)"
		$$else
			format %0rx|ct(0)|%6lx|sl(0)|^n
		$$endif
		sformat %0ln%-22lt%-10r!List
		$$ifdef(cat)
			cat "$(cat)"
		$$else
			cat List
		$$endif
		cost 0
		addaslist inheritopts
		$$ifdef(totalcostformula)
			totalcostformula "$(totalcostformula)"
		$$else
			totalcostformula "totalcost(@bc@,a,1,1,1)"
		$$endif
}}


# charmax -- characteristic maximum, usually used in package deals to set upper and lower limits
# for "normal" char maxima.

$$macro charmax(name, charName, cost)
{{
	item "$(name)"
	cat "CHAR Max."
	formula "x<0?integer(x*$(cost)/2):round(x*$(cost))+0*m_$(charName)"
	level 0
	varname "max_$(charName)"
	prereq "Disadvantages:Normal Characteristic Maxima|$NormalMaxima<>0"

	format "%0rx|ct(0)|%7ln: ^x|@v@<0?'':'+'|^v (Max. ^x|m_$(charName)|)"
	sformat %0ln%-25lt%-10r!$(cost)/pt.
	adj "mx_$(charName)+x"
	opt	exp "Maximum" "m_$(charName)"
		end
}}


# senseList -- lists senses for use in options on powers that use/affect senses.

$$macro senseList(name, cost)
{{
$$ifdef(cost)
	add
$$else
	text
$$endif
"$(name)" "?:1;Normal Sight$$ifdef(cost),$(cost)$$endif;\
IR Vision$$ifdef(cost),$(cost)$$endif;\
UV Vision$$ifdef(cost),$(cost)$$endif;\
Hearing$$ifdef(cost),$(cost)$$endif;\
Ultrasonic Hearing$$ifdef(cost),$(cost)$$endif;\
Sonar$$ifdef(cost),$(cost)$$endif;\
Radio Listen/Transmit$$ifdef(cost),$(cost)$$endif;\
High Range Radio Hearing$$ifdef(cost),$(cost)$$endif;\
Smell$$ifdef(cost),$(cost)$$endif;\
Taste$$ifdef(cost),$(cost)$$endif;\
Spatial Awareness$$ifdef(cost),$(cost)$$endif;\
N-Ray Vision$$ifdef(cost),$(cost)$$endif;\
Clairsentience$$ifdef(cost),$(cost)$$endif;\
Radar$$ifdef(cost),$(cost)$$endif;\
Mind Scan$$ifdef(cost),$(cost)$$endif;\
Mental Awareness$$ifdef(cost),$(cost)$$endif;\
Detect$$ifdef(cost),$(cost)$$endif"
}}


# senseGroupList -- lists sense groups for use in options on powers that use/affect senses.


$$macro senseGroupList(name, cost, first, extra, extraCost)
{{
$$ifdef(cost)
	add
$$else
	text
$$endif
"$(name)" "?:1;$$ifdef(first)$(first);$$endif\
Sight$$ifdef(cost),$(cost)$$endif;\
Hearing$$ifdef(cost),$(cost)$$endif;\
Radio$$ifdef(cost),$(cost)$$endif;\
Smell/Taste$$ifdef(cost),$(cost)$$endif;\
Unusual Senses$$ifdef(cost),$(cost)$$endif;\
Mental$$ifdef(cost),$(cost)$$endif\
$$ifdef(extra);$(extra)$$ifdef(extracost),$(extracost)$$endif$$endif"
}}


$$macro note(name)
{{
	item "$(name)"
		cost 0
		cat Note
		editdlg 1
		format "%0r! %7ln"
		sformat "%0ln"
}}
